<?php
/**
 * Template Name: Country Entry Form
 *
 * @package WordPress
 * @subpackage Twenty_Fourteen
 * @since Twenty Fourteen 1.0
 */
$menukey = "country-entry";
if (get_current_user_id() == 0) {
    $current_slug = add_query_arg( array(), $wp->request );
    $pageName = site_url() . '/' . $current_slug;
    header('Location:' . site_url() . "/login?redirect_to={$pageName}"); /* Redirect browser */ //exit;
}

get_header();
$userid = get_current_user_id();

require('pdo_lib.php');
$lan = get_locale();
$activeFunction = array('gCurrencyListCountry');
include_once ('esigl_combo_script_pdo.php');
include_once ('languages/lang_switcher.php');

?>

<script type="text/javascript">
    var $ = jQuery.noConflict();
	var userId = "<?php echo get_current_user_id(); ?>"; 
	var menukey = "<?php echo $menukey; ?>";	
</script>
<div id="Content">
	<?php echo do_shortcode("[CreateMyUsersShortcode]"); ?>
    <div class="content_wrapper clearfix">
        <!-- .sections_group -->
        <div class="sections_group">
            <div class="entry-content" itemprop="mainContentOfPage">
                <div id="columns" class="section mcb-section " style="padding-top:10px; padding-bottom:0px;">
                    <div class="section_wrapper mcb-section-inner">
                        <div class="wrap mcb-wrap one valign-top clearfix">
                            <div class="mcb-wrap-inner">
								<div class="column mcb-column one column_column margin-b0">
										<!--start of Row-->
										<div class="column mcb-column one column_column margin-b0">
                                            <div class="tbl-header1 pull-right quarterly_dashboard button-stroke">
                                                <label>	                                                       
                                                    <a  style="display:none;" href="javascript:void(0);" title="<?php echo $TEXT['Back to List']; ?>" onClick="onListPanel()" class="button  button_left button_size_2 button_grey kill_the_icon button_js btn-list"><span class="button_icon"><i class="fa fa-reply fa-lg"></i></span><span class="button_label"><b><?php echo $TEXT['Back to List']; ?></b></span></a>
                                                    <!--<a  href="javascript:void(0);" title="Add" onClick="onFormPanel()" class="button  button_left button_size_2 button_grey kill_the_icon button_js btn-form"><span class="button_icon"><i class="fa fa-plus fa-lg"></i></span><span class="button_label"><b>Add</b></span></a>-->
													<a id="PrintBTN" href="javascript:void(0);" title="<?php echo $TEXT['Print']; ?>" onClick="print_function('print')" class="button  button_left button_size_2 button_grey kill_the_icon button_js"><span class="button_icon"><i class="fa fa-print fa-lg"></i></span><span class="button_label"><b><?php echo $TEXT['Print']; ?></b></span></a>
													<a id="PrintBTN1" href="javascript:void(0);" title="<?php echo $TEXT['Excel']; ?>" onClick="print_function('excel')" class="button  button_left button_size_2 button_grey kill_the_icon button_js"><span class="button_icon"><i class="fa fa-file-excel-o fa-lg"></i></span><span class="button_label"><b><?php echo $TEXT['Excel']; ?></b></span></a>
                                                </label>
                                            </div>
										</div>
										<div class="column_divider "><hr class="no_line"></div>
										<!--End of Row-->
										
									<!--</div>-->
								</div>
								<div class="column_divider "><hr class="no_line"></div>
								<!--End of Row-->
								<div class="column mcb-column one column_column">
									<div id="list-panel">
										<table id="CountryTable" class="table table-striped table-bordered display table-hover" cellspacing="0">
											<thead>
												<tr>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['SL.']; ?></th>
													<th style="text-align: left;" data-priority="3"><?php echo $TEXT['Country Code']; ?></th>
													<th style="text-align: left;" data-priority="3"><?php echo $TEXT['Country Name']; ?></th>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['Center']; ?></th>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['Zoom Level']; ?></th>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['Currency Name']; ?></th>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['Report Expected Date']; ?></th>
													<th style="text-align: left;" data-priority="3"><?php echo $TEXT['Reporting Frequency']; ?></th>
													<th style="text-align: right;" data-priority="3"><?php echo $TEXT['AMC Months']; ?></th>
													<th style="text-align: center;" data-priority="3"><?php echo $TEXT['Action']; ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>			                   
									</div>
									
									<div id="form-panel" class="" style="display: none;">
										<div class="panel-heading"><?php echo $TEXT['Country Entry Form']; ?></div>
										
										<div class="nav-data-form">
										<form novalidate="" data-validate="parsley" id="Country_form">
										
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="ISO3"><?php echo $TEXT['Country Code']; ?><span class="red">*</span></label>
													<input name="ISO3" id="ISO3" maxlength="20" class="form-control-ctm parsley-validated" data-required="true" placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="CountryName"><?php echo $TEXT['Country Name']; ?> <span class="red">*</span></label>
													<input name="CountryName" id="CountryName" class="form-control-ctm parsley-validated" data-required="true" placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->											
											
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="CenterLatitude"><?php echo $TEXT['Center Latitude']; ?> <span class="red">*</span></label>
													<input name="CenterLatitude" id="CenterLatitude" maxlength="30" class="form-control-ctm parsley-validated numberinput" data-required="true" placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
																												
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="CenterLong"><?php echo $TEXT['Center longitude']; ?> <span class="red">*</span></label>
													<input name="CenterLong" id="CenterLong" maxlength="20" class="form-control-ctm parsley-validated numberinput" data-required="true" placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
																																								
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="ZoomLevel"><?php echo $TEXT['Zoom Level']; ?>  <span class="red">*</span></label>
													<input name="ZoomLevel" id="ZoomLevel" maxlength="20" class="form-control-ctm parsley-validated numberinput" data-required="true" placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="CurrencyId"><?php echo $TEXT['Currency Name']; ?><span class="red">*</span></label>
													<select class="form-control-ctm parsley-validated" name="CurrencyId" id="CurrencyId" data-required="true">
													<option selected="true" value=""><?php echo $TEXT['Select Currency']; ?></option></select>
													
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											
																																																			
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="LMISReportExpectedDate"><?php echo $TEXT['Report Expected Date']; ?>  </label>
													<input name="LMISReportExpectedDate" id="LMISReportExpectedDate" maxlength="20" class="form-control-ctm parsley-validated numberinput"  placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											<!--start of Row-->
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<div class="form-group-ctm">
													<label class="control-label-ctm" for="AMCMonths"><?php echo $TEXT['AMC Months']; ?><span class="red">*</span></label>
													<input name="AMCMonths" id="AMCMonths" maxlength="20" class="form-control-ctm parsley-validated numberinput" data-required="true"  placeholder="<?php echo $TEXT['input here...']; ?>" type="text">
												</div>
											</div>
											<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											
											<!--start of Row-->
											<!--<div class="column mcb-column one-fourth column_column margin-b0">&nbsp;</div>
											<div class="column mcb-column one-second column_column margin-b0">
												<label class="control-label-ctm" style="padding-left:5px;" ><?php echo $TEXT['Reporting Frequency']; ?></label>&nbsp;&nbsp;&nbsp;
												<label class="label-radio">
													<input type="radio" name="FrequencyId" id="levelType1" style="margin-top:17px;" value="1" onclick="checkNational()"/>
													<?php echo $TEXT['Monthly']; ?>
												</label>
												&nbsp;&nbsp;
												<label class="label-radio">
													<input type="radio" name="FrequencyId" id="levelType2" style="margin-top:17px; margin-bottom:17px;" value="2" onclick="checkFacility()"/>
													<?php echo $TEXT['Quarterly']; ?>
												</label>
												
												<div class="alert2 alert_error" id ="warning_panel">
													 
													<?php echo $TEXT['Are you sure, you want to switching reporting frequency? It will be effected on all reports and LMIS entry']; ?>
												</div>&nbsp;
												
											</div>
											
											<div class="column mcb-column one-fourth column_column margin-b0">
											</div>
											<div class="column_divider "><hr class="no_line"></div>-->
											<!--End of Row-->
								
											<!--start of Row-->
											<div class="column mcb-column one column_column margin-b0">
												<input type="text" id="RecordId" name="RecordId" style="display: none;"/>
												<input type="hidden" style="display:none;" id="userId" value="<?php echo get_current_user_id(); ?>"/>
												<center>
													<a id="submitItemList" class="button  button_green button_js" href="javascript:void(0);"><span class="button_label"><?php echo $TEXT['Submit']; ?></span></a>
													<a class="button button_js" href="javascript:void(0);" onClick="onListPanel()"><span class="button_label"><?php echo $TEXT['Cancel']; ?></span></a>			                    
												</center>
											</div>
											<div class="column_divider "><hr class="no_line"></div>
											<!--End of Row-->
											
										</form>
										</div>
									</div>
								</div>
								<div class="column_divider "><hr class="no_line"></div>
								<!--End of Row-->
								
							</div>
						</div>
					</div>
				</div>
            </div><!-- #primary -->
        </div><!-- #primary -->
    </div><!-- #primary -->
</div><!-- #main-content -->

<style>
.alert2 {
    margin-bottom: 0px;
    padding: 0px 18px 0px 9px;
    position: relative;
    -webkit-border-radius: 5px;
    border-radius: 5px;
}
</style>

<script>

	function print_function(type) {
		var reportHeaderList = new Array();
		var sqlParameterList = new Array();  
		
		/*PDF page type. Capital P=Portrait and Capital L=Landscape and when black then auto take depend on width*/
		var pageType = '';
		// var pageType = 'P';
		//var pageType = 'L';
		
		/*When serial column not exist in datatable then 0 if exist then 1*/
		var useSl = 1;

		/*Report Title*/ 
		var reportHeaderName = "<?php echo $TEXT['Country List']; ?>";

		/*Report header list*/
		reportHeaderList[0] = reportHeaderName;
		//reportHeaderList[1] = $('#ARegionId').find(":selected").text();
		//reportHeaderList[1] = encodeURIComponent('Arv & art %&% jaki');
		
		/*Report save name. Not allow any type of special character*/
		var reportSaveName = "Country List";
		reportSaveName = reportSaveName.replace(/ /g, "_");
		reportSaveName = reportSaveName.replace(/\//g, "_");
		reportSaveName = reportSaveName.replace(/#/g, "_");
		reportSaveName = reportSaveName.replace(/%/g, "_");

		/*sql command parameters list*/
		 //sqlParameterList[0] = (($('#ARegionId').val() == '') ? 0 : $('#ARegionId').val());
		 //sqlParameterList[1] = (($('#AllDistrictId').val() == '') ? 0 : $('#AllDistrictId').val());

		/*SQL Command function Name*/
		var sqlFunctionName = "getCountryData";
		
		print_function_generation(baseUrlTemplate,type,sqlFunctionName,reportHeaderList,sqlParameterList,pageType,reportSaveName,useSl,menukey);
	}
	
</script>


<!-- DataTable -->
<link type="text/css" href="<?php echo CHILD_THEME_URI; ?>/datatable/jquery.dataTables.min.css" rel="Stylesheet"/>
<script type="text/javascript" src="<?php echo CHILD_THEME_URI; ?>/datatable/jquery.dataTables.min.js"></script>
<!-- font-awesome -->
<link rel="stylesheet" type="text/css" href="<?php echo CHILD_THEME_URI; ?>/css/font-awesomev4/css/font-awesome.min.css"/>
<script type="text/javascript" src="<?php echo CHILD_THEME_URI; ?>/js/jquery.force.numeric.js"></script>
<script type="text/javascript" src="<?php echo CHILD_THEME_URI; ?>/country.js?ver=4"></script>
<script src='<?php echo CHILD_THEME_URI; ?>/report/dynamicexport/print_excel_pdf_initialize_pagination.js?ver=1'></script>


<?php
get_footer();
?>

